package gov.va.med.mhv.admin.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.common.data.model.InPersonAuthentication;

@Repository
public interface InPersonAuthenticationRepository extends JpaRepository<InPersonAuthentication, Long> {

	@Query("select ipa from InPersonAuthentication ipa where ipa.mviAuthenticationStatus = 'PENDING_UNAUTH'")
	List<InPersonAuthentication> getMVIPendingUnauthPatients();

	@Query("select ipa from InPersonAuthentication ipa where ipa.patient.id = :patientId")
	List<InPersonAuthentication> getAuthenticationForPatient(@Param("patientId") Long patientId);

	@Query("select ipa from InPersonAuthentication ipa where ipa.mviAuthenticationStatus = 'PENDING_UNAUTH'")
	List<InPersonAuthentication> getMVIPendingAuthPatients();
}